﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace MojaDrugaGra;

public class Game1 : Game
{
    private GraphicsDeviceManager _graphics;
    private SpriteBatch _spriteBatch;

    public Game1()
    {
        _graphics = new GraphicsDeviceManager(this);
        Content.RootDirectory = "Content";
        IsMouseVisible = true;

        _graphics.GraphicsProfile = GraphicsProfile.Reach;
    }

    private BasicEffect efekt;
    private Prostopadloscian prostopadloscian;

    protected override void Initialize()
    {
        // TODO: Add your initialization logic here
        efekt = new BasicEffect(_graphics.GraphicsDevice);
        efekt.VertexColorEnabled = true;
        efekt.Projection = Matrix.CreatePerspective(
            2.0f * _graphics.GraphicsDevice.Viewport.AspectRatio,
            2.0f, 1.0f, 10.0f);
        efekt.View = Matrix.CreateLookAt(
            new Vector3(0, 0, 2.5f),
            new Vector3(0, 0, 0),
            new Vector3(0, 1, 0));
        efekt.World = Matrix.Identity;

        //efekt.EnableDefaultLighting();
        //efekt.AmbientLightColor = Color.DarkGray.ToVector3();

        efekt.EnableDefaultLighting();
         efekt.AmbientLightColor = Color.Gray.ToVector3();

         //cialo doskonale czarne
         efekt.AmbientLightColor = Color.Black.ToVector3();
         efekt.DiffuseColor = Color.Black.ToVector3();
         efekt.SpecularColor = Color.Black.ToVector3();
         efekt.EmissiveColor = Color.Black.ToVector3();

         //zrodla swiatla
         efekt.DirectionalLight0.DiffuseColor = Color.White.ToVector3();
         efekt.DirectionalLight0.SpecularColor = Color.Gray.ToVector3();

        efekt.SpecularColor = Color.White.ToVector3();
        efekt.SpecularPower = 16;
        efekt.DiffuseColor = Color.White.ToVector3();
        efekt.AmbientLightColor = Color.Gray.ToVector3();
        efekt.EmissiveColor = Color.White.ToVector3();

        prostopadloscian = new Prostopadloscian(
            this, efekt, 1.5f, 1.0f, 2.0f, Color.Yellow);
        this.Components.Add(prostopadloscian);        

        base.Initialize();
    }

    protected override void LoadContent()
    {
        _spriteBatch = new SpriteBatch(GraphicsDevice);

        // TODO: use this.Content to load your game content here
    }

    protected override void Update(GameTime gameTime)
    {
        KeyboardState stanKlawiatury = Keyboard.GetState();
        GamePadState stanGamepada = GamePad.GetState(PlayerIndex.One);

        if (stanGamepada.Buttons.Back == ButtonState.Pressed || stanKlawiatury.IsKeyDown(Keys.Escape))
            Exit();

        // TODO: Add your update logic here
        float katObrotu = 0.01f;        
        if (stanKlawiatury.IsKeyDown(Keys.LeftShift) || stanKlawiatury.IsKeyDown(Keys.RightShift))
            katObrotu *= 10;

        if (stanKlawiatury.IsKeyDown(Keys.Left) || stanGamepada.IsButtonDown(Buttons.DPadLeft))
            prostopadloscian.MacierzSwiata *= Matrix.CreateRotationY(katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.Right) || stanGamepada.IsButtonDown(Buttons.DPadRight))
            prostopadloscian.MacierzSwiata *= Matrix.CreateRotationY(-katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.Up) || stanGamepada.IsButtonDown(Buttons.DPadUp))
            prostopadloscian.MacierzSwiata *= Matrix.CreateRotationX(katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.Down) || stanGamepada.IsButtonDown(Buttons.DPadDown))
            prostopadloscian.MacierzSwiata *= Matrix.CreateRotationX(-katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.OemPeriod))
            prostopadloscian.MacierzSwiata *= Matrix.CreateRotationZ(katObrotu);
        if (stanKlawiatury.IsKeyDown(Keys.OemComma))
            prostopadloscian.MacierzSwiata *= Matrix.CreateRotationZ(-katObrotu);        

        Vector2 wychylenieLewegoGrzybka = stanGamepada.ThumbSticks.Left;
        prostopadloscian.MacierzSwiata *= Matrix.CreateRotationY(katObrotu * wychylenieLewegoGrzybka.X);
        prostopadloscian.MacierzSwiata *= Matrix.CreateRotationX(-katObrotu * wychylenieLewegoGrzybka.Y);

        Vector2 wychyleniePrawegoGrzybka = stanGamepada.ThumbSticks.Right;
        prostopadloscian.MacierzSwiata *= Matrix.CreateRotationY(10 * katObrotu * wychyleniePrawegoGrzybka.X);
        prostopadloscian.MacierzSwiata *= Matrix.CreateRotationX(-10 * katObrotu * wychyleniePrawegoGrzybka.Y);

        base.Update(gameTime);
    }

    protected override void Draw(GameTime gameTime)
    {
        GraphicsDevice.Clear(Color.Black);

        // TODO: Add your drawing code here

        base.Draw(gameTime);
    }
}
